using System;
using Server.Network;

namespace Server.Items
{
	public class FishCoral : Item
	{
		[Constructable]
		public FishCoral() : this( 1 )
		{
		}

		[Constructable]
		public FishCoral( int amount ) : base( 15098 )
		{
			Stackable = false;
			Weight = 0.1;
			Amount = amount;
			Name = "Coral";
		}

		public FishCoral( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class WhitePearl : Item
	{
		[Constructable]
		public WhitePearl() : this( 1 )
		{
		}

		[Constructable]
		public WhitePearl( int amount ) : base( 12694 )
		{
			Stackable = true;
			Weight = 0.1;
			Amount = amount;
			Name = "White Pearl";
		}

		public WhitePearl( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishSeaHorse : Item
	{

		[Constructable]
		public FishSeaHorse() : this( 1 )
		{
		}

		[Constructable]
		public FishSeaHorse( int amount ) : base( 15120 )
		{
			Stackable = true;
			Weight = 1.0;
			Amount = amount;
			Name = "Sea Horse";
		}

		

		public FishSeaHorse( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x1EA3, 0x1EA4 )]
	public class SmallDecorativeNet : Item
	{

		[Constructable]
		public SmallDecorativeNet() : base( 0x1EA3 )
		{
			Weight = 7.0;
			Name = "a small decorative net";
		}

		public SmallDecorativeNet( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x1EA6, 0x1EA5 )]
	public class LargeDecorativeNet : Item
	{

		[Constructable]
		public LargeDecorativeNet() : base( 0x1EA6 )
		{
			Weight = 10.0;
			Name = "a large decorative net";
		}

		public LargeDecorativeNet( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	public class FishBones : Item
	{
		[Constructable]
		public FishBones() : this( 1 )
		{
		}
      
      [Constructable]
		public FishBones( int amount ) : base( 0x3B0C )
		{
			Stackable = true;
			Weight = 0.2;
			Name = "Fish Bones";
			Hue = 0x47E;
			Amount = amount;
		}

		public FishBones( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	[FlipableAttribute( 0x8A6, 0x8A5 )]
	public class RopeLadder : Item
	{

		[Constructable]
		public RopeLadder() : base( 0x8A6 )
		{
			Weight = 5.0;
		}

		public RopeLadder( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}	
}